<?php

class especial_Model_DbTable_Chamado extends Zsam_Db_Table {
	
	protected $_name = 'chamado';
	
    public function __construct(){

		$controller 	 	= Zend_Controller_Front::getInstance()->getRequest();
		$nome_controller 	= $controller->getControllerName(); // PEGA O NOME DA CONTROLADORA
		
		$action = $controller->getActionName();

		parent::__construct();
		$registry = Zend_Registry::getInstance();
		$this->_setAdapter($registry->get('db2'));

        $auth = Zend_Auth::getInstance();
        if ($auth->hasIdentity()) {
            $user 			= $auth->getStorage()->read();
            $funcao 		= @$user['FUNCAO'];
            $id 			= @$user['ID'];
            $nome 			= @$user['NOME'];
            $level 			= @$user['NIVEL'];
            $funcao 		= @$user['FUNCAO'];
            $this->email  	= @$user['EMAIL'];
			$this->usuario	= $id;
        }
		
		if($nome_controller == 'chamadotodos'){
			$this->_restrict = "1";		
			$this->_conf['ASSUNTO']['edit']				= 'N';
			$this->_conf['CATEGORIA_CHAMADO']['edit']	= 'N';
			$this->_conf['CLIENTE']['edit']				= 'N';
			$this->_conf['USUARIO']['edit']				= 'N';
			$this->_conf['CONTROLADORA']['edit']		= 'N';
		}else{
			$this->_restrict = "DATA_FECHAR IS NULL";		
		}
		
		if ($action == 'upd') {
			$this->_conf['ASSUNTO']['edit']				= 'N';
			$this->_conf['CATEGORIA_CHAMADO']['edit']	= 'N';
			$this->_conf['CLIENTE']['edit']				= 'N';
			$this->_conf['USUARIO']['edit']				= 'N';
			$this->_conf['CONTROLADORA']['edit']		= 'N';
		}
		
	}
	
	var $_conf = array(
		'ID' 						=> array('edit' => 'N','grid' => true),
		'CLIENTE' 					=> array('NULLABLE' => true,'case' => 'none','grid' => true),
		'ITEM' 						=> array('NULLABLE' => true,'edit' => 'N','grid' => true),
		'USUARIO'					=> array('grid' => true, 'help' => 'help_digite_codigo_func_nao_esta_relacionado'),
		'EMAIL_USUARIO'				=> array('edit' => 'N','grid' => true),
		'ASSUNTO' 					=> array('NULLABLE' => false,'grid' => true),
		'CONTROLADORA'				=> array('NULLABLE' => false,'grid' => true,'help' => 'help_controladora'),
		'TEXTO' 					=> array('NULLABLE' => false),
		'STATUS' 					=> array('case' => 'none','grid' => true),
		'DATA_ABERTURA'				=> array('edit' => 'N','grid' => true),
		'DATA_INICIO_ATENDIMENTO'	=> array('edit' => 'N','grid' => true),
		'CONCLUSAO'					=> array('VP' => array('A' => 'solicitacao_atividade_de_acesso_restrito_do_suporte', 'S' => 'sugestao_melhoria_atendida', 'N' => 'sugestao_melhoria_nao_atendida', '1' => 'duvida_usuario', '2' => 'dificuldade_usuario', '3' => 'erro_cliente_config', '4' => 'erro_sistema_config', '5' => 'erro_sistema')),
		'FECHAR'					=> array('VP' => array('S' => 'SIM', 'N' => 'NAO')),
		'DATA_FECHAR'				=> array('edit' => 'N'),
		'CATEGORIA_CHAMADO' 		=> array('NULLABLE' => false,'grid' => true),
		'FUNC_ALTERACAO'			=> array('edit' => 'N'),
		'DATA_ALTERACAO'			=> array('edit' => 'N'),
		'GRID'    		   			=> array('type' 		=> 'itemGridAuto',
										'configitem' 	=> 'GRID',
										'model' 		=> 'especial_Model_DbTable_Chamadoitens',
										'columns' 		=> array('NUM_ITEM','DATA_RESPOSTA','TEXTO'),
										'idWhere' 		=> array('CHAMADO','NUM_ITEM'),
										'buttons'		=> array('edit'=>'S', 'del' => 'N')),
         
		'GRID1'         			=> array( 'type'         => 'cotacaoanexo', 
										  'model'        => 'especial_Model_DbTable_Chamadoanexo',
										  'configitem'   => 'GRID1',
										  'columns'      => array('ID','CHAMADO','NOME_ANEXO','TIPO_ANEXO'), 
										  'idWhere'      => 'CHAMADO',
										  'controller'   => 'chamadoanexo',
										  'buttons'		 => array('rem'=>'N')),													
										
    );

	var $_referenceMap = array(
		
		'CLIENTE' => array(
			'columns'       => 'CLIENTE',
			'refTableClass' => 'admin_Model_DbTable_Cliente',
			'refColumns'    => 'CODIGO',
			'refTitle'      => 'CLIENTE',
			'Db2'			=> 'S'
		),

		'CATEGORIA_CHAMADO' => array(
			'columns'       => 'CATEGORIA_CHAMADO',
			'refTableClass' => 'especial_Model_DbTable_Chamadocategoria',
			'refColumns'    => 'ID',
			'refTitle'      => 'CATEGORIA_CHAMADO',
			'Db2'			=> 'S'
		),

    	'GRID' => array(
            'columns' 		=> 'GRID',
            'refTableClass' => 'especial_Model_DbTable_Chamadoitens',
            'refColumns' 	=> 'CHAMADO',
            'refTitle' 		=> 'GRID'
		),

		'GRID1' => array(
            'columns' 		=> 'GRID',
            'refTableClass' => 'especial_Model_DbTable_Chamadoanexo',
            'refColumns' 	=> 'ID',
            'refTitle' 		=> 'GRID'
		)
        
	);


	public function selectcheckbox($model,$attribs,$idItem = null)
    {
		
    	$table 			= new $model();
    	$controller 	= Zend_Controller_Front::getInstance()->getRequest();
    	$rowset 		= array();
    	$adapter 		= $table->getAdapter();
    	$var 			= $table->info();
        

        //@$idItem = $_SESSION['item']['id'];
        if (is_null($idItem))
        {
            $idItem = $controller->getParam('id');
        }
		

        if (isset ( $attribs ['idWhere'] ))
        {

            if(isset ( $attribs ['valueWhere'] ))
            {
                $idItem = $attribs ['valueWhere'];
            }

            $tipo_var = gettype($attribs ['idWhere']);


            $select = $table->select()
            ->setIntegrityCheck(false)
            ->from( $var ['name'], $attribs ['columns']);

            if ($tipo_var == 'array')
            {
                $idItem=$controller->getParam('id');
                $id_grid = explode(':',$idItem);

                if (isset($attribs ['restrict']))$select = $select->where($attribs['idWhere'][0] . "=?",$id_grid[0])->where($attribs['idWhere'][1] . "=?",$id_grid[1])->where($attribs['restrict']);

                if (isset($attribs ['order_item']))
                {
                    $select 	= $select->where($attribs['idWhere'][0] . "=?",$id_grid[0])->where($attribs['idWhere'][1] . "=?",$id_grid[1])->order($attribs['order_item']);
                }
                else
                {
                    $select 	= $select->where($attribs['idWhere'][0] . "=?",$id_grid[0])->where($attribs['idWhere'][1] . "=?",$id_grid[1]);
                }
            }
            else
            {

                $idItem = explode(':',$idItem);
                $idItem = $idItem[0];

                if (isset($attribs ['restrict']))$select = $select->where($attribs['idWhere'] . "=?",$idItem)->where($attribs['restrict']);

                if (isset($attribs['order_item']))
                {
                    $select 	= $select->where($attribs['idWhere'] . "=?",$idItem)->order($attribs['order_item']);
                }
                else
                {
                    $select 	= $select->where($attribs['idWhere']. "=?",$idItem);
                }
            }
        }
		
        return $rowset = $adapter->fetchAll($select);
    }

   	public function beforeUpdate(array $data,$where)
	{
		$registry   	= Zend_Registry::getInstance();
		$db2 			= $registry->get('db2');
		
		/*Montagem do banco*/
		$banco_cliente		= 'ciserpco_'.$data['CLIENTE'];
		$config = new Zend_Config_Ini ( APPLICATION_PATH . '/configs/application.ini', APPLICATION_ENV );
		$banco_cliente		= substr($config->Username,0,9).$data['CLIENTE'];
                    
		$dbcli = new Zend_Db_Adapter_Pdo_Mysql(array(
				'host'      => $config->Host,
                'username'  => $config->Username,
                'password'  => $config->Password,
                'dbname'    => $banco_cliente
        ));

		$dados_config = $dbcli->select()->where(1)->from('config');
		$dados_config = $dbcli->fetchAll($dados_config);
		$email_copia1 = $dados_config[0]['EMAIL_COPIA_SUPORTE1'];
		$email_copia2 = $dados_config[0]['EMAIL_COPIA_SUPORTE2'];
		$email_copia3 = $dados_config[0]['EMAIL_COPIA_SUPORTE3'];
		
		if ($data['FECHAR'] == 'S'){
			$data['DATA_FECHAR']= date("Y-m-d H:i:s");
			$dbcli->update('chamado',$data,$where);
			$dados_chamado_categoria 	= $db2->select()->from('chamadocategoria')->where("ID = ?", $data['CATEGORIA_CHAMADO']);
			$dados_chamado_categoria 	= $db2->fetchAll($dados_chamado_categoria);
							
			$email_setor		 		= @$dados_chamado_categoria[0]['EMAIL'];
			$cc		   					= $email_setor;
			if(!is_null($email_copia1)){
				$cc .= ",".$email_copia1; 
			}
			if(!is_null($email_copia2)){
				$cc .= ",".$email_copia2; 
			}
			if(!is_null($email_copia3)){
				$cc .= ",".$email_copia3; 
			}
			$setor  					= @$dados_chamado_categoria[0]['SETOR'];
			$email						= @$data['EMAIL_USUARIO'];
			$assunto   					= "Fechamento de Chamado";
			$mensagem  = 'Caro Sr./Sra.,' 
						 .'<br/>'
						 .'<br/>'
						 .'O Chamado: '.$data['ID'].' - Assunto: '.$data['ASSUNTO'].' foi Encerrado.'
						 .'<br/>'
						 .'<br/>'
						 .'<br/>'
						 .'-->Caso a questão ainda persista, solicitamos abrir um novo chamado referenciando o mesmo.'
						 .'<br/>'
						 .'<br/>'
						 .'<br/>'
						 .'<br/>'
						 .'******* NAO RESPONDA ESTE EMAIL -> ACESSE O CIS-ERP PARA SE COMUNICAR COM NOSSO SUPORTE *******';
			
			$mail = new Cisweb_Mail_Mail();
			$mail->enviaEmailChamado($email, $email_setor, $assunto, $mensagem, $data, $cc);
		}

		
        return parent::beforeUpdate($data,$where);
		
	}
	
	public function beforeInsert(array $data){
	
        $cript = new Zsam_Crypt_Cisweb();

		/*Montagem do banco*/
		$usuario_cli		= $data['USUARIO'];
		$config = new Zend_Config_Ini ( APPLICATION_PATH . '/configs/application.ini', APPLICATION_ENV );
 		$banco_cliente		= substr($config->Username,0,9).$data['CLIENTE'];
                   
		$dbcli = new Zend_Db_Adapter_Pdo_Mysql(array(
				'host'      => $config->Host,
                'username'  => $config->Username,
                'password'  => $config->Password,
                'dbname'    => $banco_cliente
        ));

        /*Exemplo consulta*/
		$usuario  = $dbcli->select()->where("ID = ?", $usuario_cli)->from('usuario');
		$usuario  = $dbcli->fetchAll($usuario);
		
		if (count($usuario) == 0){
			echo 'Usuario: '.$usuario_cli.' nao encontrado no Cliente: '.$banco_cliente;
			die();
		}
		
		$dados_chamado	= $dbcli->select()->from('chamado',array("MAX(ITEM) AS ITEM"));
    	$dados_chamado 	= $dbcli->fetchAll($dados_chamado);
		$max_item 		= $dados_chamado[0]['ITEM'] + 1;
  
		$data['ITEM']   				= $max_item;
		$data['EMAIL_USUARIO']  		= $cript->decode($usuario[0]['EMAIL']);
		$data['DATA_ABERTURA'] 			= date("Y-m-d H:i:s");
		$data['DATA_INICIO_ATENDIMENTO']= date("Y-m-d H:i:s");
		
		return parent::beforeInsert($data);
	}
	
	public function afterInsert($id){

		$registry   	= Zend_Registry::getInstance();
		$db2 			= $registry->get('db2');
		
		$dados_chamado	= $db2->select()->where("ID = ?", $id)->from('chamado');
    	$dados_chamado 	= $db2->fetchAll($dados_chamado);
		$dados_chamado	= $dados_chamado[0];

		/*Montagem do banco*/
		$config = new Zend_Config_Ini ( APPLICATION_PATH . '/configs/application.ini', APPLICATION_ENV );
		$banco_cliente		= substr($config->Username,0,9).$dados_chamado['CLIENTE'];
                    
		$dbcli = new Zend_Db_Adapter_Pdo_Mysql(array(
				'host'      => $config->Host,
                'username'  => $config->Username,
                'password'  => $config->Password,
                'dbname'    => $banco_cliente
        ));

		$dbcli->insert('chamado',$dados_chamado);
		
		$usuario_cli = $dados_chamado['USUARIO'];
		$usuario  	 = $dbcli->select()->where("ID = ?", $usuario_cli)->from('usuario');
		$usuario  	 = $dbcli->fetchAll($usuario);
		$nome_user	 = $usuario[0]['NOME'];

		$dados_config = $dbcli->select()->where(1)->from('config');
		$dados_config = $dbcli->fetchAll($dados_config);
		$email_copia1 = $dados_config[0]['EMAIL_COPIA_SUPORTE1'];
		$email_copia2 = $dados_config[0]['EMAIL_COPIA_SUPORTE2'];
		$email_copia3 = $dados_config[0]['EMAIL_COPIA_SUPORTE3'];
		
		$dados_chamado_categoria 	= $db2->select()->from('chamadocategoria')->where("ID = ?", $dados_chamado['CATEGORIA_CHAMADO']);
    	$dados_chamado_categoria 	= $db2->fetchAll($dados_chamado_categoria);
						
    	$email_setor		 		= @$dados_chamado_categoria[0]['EMAIL'];
		$cc		   					= $email_setor;
		if(!is_null($email_copia1)){
			$cc .= ",".$email_copia1; 
		}
		if(!is_null($email_copia2)){
			$cc .= ",".$email_copia2; 
		}
		if(!is_null($email_copia3)){
			$cc .= ",".$email_copia3; 
		}
    	$setor  					= @$dados_chamado_categoria[0]['SETOR'];
		$email						= @$dados_chamado['EMAIL_USUARIO'];
		$assunto   					= "Abertura de Chamado pelo nosso ". $setor . " - para o Usuário: ". $nome_user ;
		$mensagem  = 'Caro Sr./Sra.,' 
					 .'<br/>'
					 .'<br/>'
					 .'O Chamado: '.$dados_chamado['ID'].' - Assunto: '.$dados_chamado['ASSUNTO'].' foi Aberto pelo nosso '. $setor
					 .'<br/>'
					 .'<br/>'
					 .'<br/>'
					 .'--> '. $dados_chamado['TEXTO']
					 .'<br/>'
					 .'-->Acesse a Controladora de Chamados de Suporte para dar continuidade a este atendimento'
					 .'<br/>'
					 .'<br/>'
					 .'<br/>'
					 .'<br/>'
					 .'******* NAO RESPONDA ESTE EMAIL -> ACESSE O CIS-ERP PARA SE COMUNICAR COM NOSSO SUPORTE *******';
		
		$mail = new Cisweb_Mail_Mail();
    	$mail->enviaEmailChamado($email, $email_setor, $assunto, $mensagem, $dados_chamado,$cc);
	}
}

?>