<?php

class especial_Model_DbTable_Food extends Zsam_Db_Table
{
    protected $_name 		= 'food';
    public $_autocomplet 	= array('CODIGO','DESCRICAO','UNIDADE','CUSTO');
    public $_restrict 		= null;

    public $_conf = array(
        'CODIGO'           => array('edit' => 'N','grid' => true),
        'FAMILIA_MAT' 	   => array('NULLABLE' => false,'grid' => true),
        'DESCRICAO' 	   => array('NULLABLE' => false,'grid' => true),
        'UNIDADE'          => array('NULLABLE' => false,'grid' => true),
		'CUSTO'            => array('grid' => true),
		'TIPO'			   => array(),
        'FUNC_ALTERACAO'   => array('edit' => 'N'),
        'DATA_ALTERACAO'   => array('edit' => 'N'),
        'REVISAO'          => array('edit' => 'N'),
        'GRID'    		   => array('type' 			=> 'itemGridAuto',
        					  	    'configitem' 	=> 'GRID',
									'model' 		=> 'especial_Model_DbTable_Fooditens',
									'columns' 		=> array('FOOD','NUM_ITEM','EMPRESA','MATERIAL','QUANTIDADE'),
									'idWhere' 		=> array('FOOD'),
									'buttons'		=> array('edit'=>'S', 'del' => 'S')),
    );

    public $_referenceMap = array(
        'FAMILIA_MAT' 		=> array(
            'columns' 		=> 'FAMILIA_MAT',
            'refTableClass' => 'core_Model_DbTable_Familiaativo',
            'refColumns' 	=> 'CODIGO',
            'refTitle' 		=> 'FAMILIA'
        ),
				      
        'GRID' => array(
            'columns' 		=> 'GRID',
            'refTableClass' => 'especial_Model_DbTable_Fooditens',
            'refColumns' 	=> 'FOOD',
            'refTitle' 		=> 'GRID'
        ),
    );
	
	public function __construct(){
        
		$controller 		= Zend_Controller_Front::getInstance()->getRequest();
	   	$nome_controller	= $controller->getControllerName();
		
		if($nome_controller == 'foodkit'){
			
			$this->_restrict = "TIPO = 'C'";
			
			$this->_conf['GRID'] = array('type' 			=> 'itemGridAuto',
										   'configitem' 	=> 'GRID',
									       'model' 			=> 'especial_Model_DbTable_Foodkititens',
									       'columns' 		=> array('FOOD','ITEM','COMP','QTD_COMP'),
									       'idWhere' 		=> array('FOOD'),
									       'buttons'		=> array('edit'=>'S', 'del' => 'S'));
										   
			$this->_referenceMap['GRID'] = array(
				'columns' 		=> 'GRID',
				'refTableClass' => 'especial_Model_DbTable_Foodkititens',
				'refColumns' 	=> 'FOOD',
				'refTitle' 		=> 'GRID'
			);							   
			
		}else if($nome_controller == 'foodkititens'){	
			$this->_restrict = null;	
			
		}else if($nome_controller == 'food'){	
			$this->_restrict = "TIPO IS NULL OR TIPO != 'C' ";
		}
	   
	    parent::__construct();
    }
	
	public function beforeInsert(array $data){
		
		$controller 		= Zend_Controller_Front::getInstance()->getRequest();
	   	$nome_controller	= $controller->getControllerName();
		
		if($nome_controller == 'foodkit'){
			$data['TIPO'] = 'C';
		}
		
		return parent::beforeInsert($data);
	}
}
