<?php

class serv_Model_DbTable_Programaitem extends Zsam_Db_Table {

	/**
	 * The default table name
	 */

	protected $_name = 'progritens';

	var $_autocomplet = array('ITEM_PROGR','NUM_ITEM','PRODUTO');

	var $_conf = array(
			'CLIENTE' 				=> array('edit' => 'N', 'grid' => true, 'NULLABLE' => false),
			'ITEM_PROGR'			=> array('edit' => 'N'),
			'NUM_ITEM' 				=> array('edit' => 'N', 'grid' => true, 'NULLABLE' => false),
            'ID'					=> array('edit' => 'N'),
			'EMPRESA' 				=> array('edit' => 'N', 'grid' => true, 'NULLABLE' => false),
			'PRODUTO' 				=> array('autocomplete'=>'Y','NULLABLE' => false),
			'DESCRICAO_ITEM_NOVO'	=> array('edit' => 'N'),//nao esta sendo usado seria para cadastrar item novo
			'CUSTOM1'				=> array('edit' => 'N'),
			'DESC_CUSTOM1'			=> array("VP" => ""),
			'CUSTOM2'				=> array('edit' => 'N'),
			'DESC_CUSTOM2'			=> array("VP" => ""),
			'CUSTOM3'				=> array('edit' => 'N'),
			'DESC_CUSTOM3'			=> array("VP" => ""),
	        'CFOP' 					=> array('NULLABLE' => false),
	        'QUANTIDADE' 			=> array('NULLABLE' => false),
			'DATANECESSIDADE' 		=> array('edit' => 'N'),
			'PRECO_UNITARIO' 		=> array('edit' => 'S','NULLABLE' => false),
			'PRECO_CUSTO' 			=> array('edit' => 'N','level'=>5),
			'PRECO_BASE' 			=> array('edit' => 'N'),
	        'PRECO_TOTAL_ITEM'		=> array('edit' => 'N'),
			'ESTOQUE'				=> array('title' => 'ESTOQUE_REVENDA','edit' => 'N'),
			'ESTOQUE_LOCACAO_NOVO' 	=> array('edit' => 'N'),
			'ESTOQUE_LOCACAO_USADO'	=> array('edit' => 'N'),
			'RESERVAS_LOCACAO' 		=> array('edit' => 'N','title'=>'pedidos_de_compra'),
			'RESERVAS_REVENDA' 		=> array('edit' => 'N'),
			'BAIXA' 				=> array('edit' => 'N'),
	        'UNI'					=> array('edit' => 'N'),
	        'NCM'					=> array('edit' => 'N'),
	        'STICMS'				=> array('edit' => 'N'),
	        'ORIGEM_SIT_TRIBUTARIA'	=> array('edit' => 'N'),
	        'BASE_DE_CALCULO_ICMS'	=> array('edit' => 'N'),
	        'PERCENTUAL_REDUCAO_BC_ICMS'=> array(),
	        'MODALIDADE_BC_ICMS'	=> array(),
	        'ALIQUOTA_ICMS'			=> array('edit' => 'N'),
	        'TOTAL_ICMS'			=> array('edit' => 'N'),
	        'BASE_DE_CALCULO_ICMS_ST'=> array('edit' => 'N'),
			'MVA_ST' 				=> array('edit' => 'N'),
			'MODALIDADE_BC_ICMSST'	=> array('edit' => 'N'),
	        'ALIQUOTA_ICMS_ST'		=> array('edit' => 'N'),
	        'TOTAL_ICMS_ST'			=> array('edit' => 'N'),
	        'STIPI'					=> array('edit' => 'N'),
	        'BASE_DE_CALCULO_IPI'	=> array('edit' => 'N'),
	        'ALIQUOTA_IPI'			=> array('edit' => 'N'),
	        'TOTAL_IPI'				=> array('edit' => 'N'),
	        'STPIS'					=> array('edit' => 'N'),
	        'BASE_DE_CALCULO_PIS'	=> array('edit' => 'N'),
	        'ALIQUOTA_PIS'			=> array('edit' => 'N'),
	        'TOTAL_PIS'				=> array('edit' => 'N'),
	        'STCOFINS'				=> array('edit' => 'N'),
	        'BASE_DE_CALCULO_COFINS'=> array('edit' => 'N'),
	        'ALIQUOTA_COFINS'		=> array('edit' => 'N'),
	        'TOTAL_COFINS'			=> array('edit' => 'N'),
			'INFORMACAO_ADICIONAL'	=> array('help'=>'help_quebrar_linha_com_;'),
	        'FUNC_ALTERACAO' 		=> array('edit' => 'N'),
			'DATA_ALTERACAO' 		=> array('edit' => 'N'),
			'REVISAO' 				=> array('edit' => 'N'),
			'DATASINC' 				=> array('edit' => 'N')
	);
	var $_referenceMap = array(
			'PRODUTO' => array(
					'columns' 	=> 'PRODUTO',
					'refTitle' 	=> 'DESCRICAO'
			),

			'EMPRESA' => array(
					'columns' 		=> 'EMPRESA',
					'refTableClass' => 'core_Model_DbTable_Empresa',
					'refColumns' 	=> 'CODIGO',
					'refTitle' 		=> 'NOME'
			),

	        'CFOP' => array(
	                'columns' 		=> 'CFOP',
	                'refTableClass' => 'core_Model_DbTable_Cfop',
	                'refColumns' 	=> 'CODIGO',
	                'refTitle' 		=> 'CFOP'
	        ),

			/*'STICMS' => array(
					'columns' 		=> 'STICMS',
					'refTableClass' => 'core_Model_DbTable_Sticms',
					'refColumns' 	=> 'CODIGO',
					'refTitle' 		=> 'STICMS'
			),
			'STIPI' => array(
					'columns' 		=> 'STIPI',
					'refTableClass' => 'core_Model_DbTable_Stipi',
					'refColumns' 	=> 'CODIGO',
					'refTitle' 		=> 'STIPI'
			),
			'STPIS' => array(
					'columns' 		=> 'STPIS',
					'refTableClass' => 'core_Model_DbTable_Stpis',
					'refColumns' 	=> 'CODIGO',
					'refTitle' 		=> 'STPIS'
			),
			'STCOFINS' => array(
					'columns' 		=> 'STCOFINS',
					'refTableClass' => 'core_Model_DbTable_Stpis',
					'refColumns' 	=> 'CODIGO',
					'refTitle' 		=> 'STCOFINS'
			),


			'ORIGEM_SIT_TRIBUTARIA' => array(
					'columns'           => 'ORIGEM_SIT_TRIBUTARIA',
					'refTableClass'     => 'core_Model_DbTable_Sittrib',
					'refColumns'        => 'CODIGO',
					'refTitle'          => 'CLASFISCAL'
			),*/

	);
	public function __construct()
	{
		parent::__construct();

		//$this->_restrict = "CODIGO_CLIENTE = ".$id;

		$controller      = Zend_Controller_Front::getInstance()->getRequest();
		$nome_controller = $controller->getControllerName(); //pegar a controladora


		$cliente = Zend_Registry::get('Cliente');
		if($cliente[0]['IND_COM_SERV'] == "I")
		{
			$this->_referenceMap['PRODUTO']['refTableClass'] = array('table1' => 'ind_Model_DbTable_Produto','table2' => 'ind_Model_DbTable_ProdutoCliente');
			$this->_referenceMap['PRODUTO']['refColumns'] = array('table1' => 'CODIGO','table2' => 'PRODUTO');
		}

		else if($cliente[0]['IND_COM_SERV'] == "C")
		{
			$this->_referenceMap['PRODUTO']['refTableClass'] = array('table1' => 'com_Model_DbTable_Produto','table2' => 'com_Model_DbTable_ProdutoCliente');
			$this->_referenceMap['PRODUTO']['refColumns'] = array('table1' => 'CODIGO','table2' => 'PRODUTO');
		}

		else
		{
			$this->_referenceMap['PRODUTO']['refTableClass'] = 'core_Model_DbTable_Ativoprodutos';
			$this->_referenceMap['PRODUTO']['refColumns'] = 'CODIGO';
		}


		if($nome_controller == 'programaitem')
		{

			//$this->_conf['PRECO_UNITARIO']['help'] = 'PRECO_BASE';


			/*if ($controller->getActionName() == 'newmodalcis')
			{
				$id = $controller->getParam('id');

				if (isset($id))
				{
					$id = explode(':', $id);

					$tableprog  = new core_Model_DbTable_Programa();
					$tableemp   = new core_Model_DbTable_Empresa();

					$tab  		= $tableprog->getAdapter()->fetchRow($tableprog->select()->where("CLIENTE = ".$id[0])->where("ITEM = " .$id[1]));
					$tabemp  	= $tableemp->find($tab['EMPRESA'])->current();


					if ($tabemp['REGIME_TRIBUTARIO'] <= 4) // regime simples.........
					{
						$this->_referenceMap['STICMS'] = array(
							'columns' 		=> 'STICMS',
							'refTableClass' => 'core_Model_DbTable_Sticmssimples',
							'refColumns' 	=> 'CODIGO',
							'refTitle' 		=> 'STICMS'
						);

						$this->_referenceMap['STIPI'] = array(
								'columns' 		=> 'STIPI',
								'refTableClass' => 'core_Model_DbTable_Stipisimples',
								'refColumns' 	=> 'CODIGO',
								'refTitle' 		=> 'STIPI'
						);

						$this->_referenceMap['STPIS'] = array(
								'columns' 		=> 'STPIS',
								'refTableClass' => 'core_Model_DbTable_Stpissimples',
								'refColumns' 	=> 'CODIGO',
								'refTitle' 		=> 'STPIS'
						);

						$this->_referenceMap['STCOFINS'] = array(
								'columns' 		=> 'STCOFINS',
								'refTableClass' => 'core_Model_DbTable_Stpissimples',
								'refColumns' 	=> 'CODIGO',
								'refTitle' 		=> 'STCOFINS'
						);

					}
				}

				}*/
			}
	}

	public function atualizar($id1,$id2,$id3)
	{
		$sql = $this->_db->prepare('UPDATE '.$this->_name.' SET NUM_ITEM = NUM_ITEM - 1 WHERE CLIENTE='.$id1.' AND ITEM_PROGR='.$id2.' AND NUM_ITEM>'.$id3);
		$sql->execute();

	}

	public function getCfopsittrib($emp, $cfop)
	{

		$tablecfop  = new core_Model_DbTable_Cfop();
		$tableemp   = new core_Model_DbTable_Empresa();

		$table_icms				= new Cisweb_Db_Abstract("sticms");
		$table_estado			= new Cisweb_Db_Abstract("stipi");
		$table_cidade			= new Cisweb_Db_Abstract("stpis");


		$tab  		= $tablecfop->find($cfop)->current();
		$tabemp  	= $tableemp->find($emp)->current();

		if ($tabemp['REGIME_TRIBUTARIO'] == 3 || $tabemp['REGIME_TRIBUTARIO'] == 4 || $tabemp['REGIME_TRIBUTARIO'] == 13 || $tabemp['REGIME_TRIBUTARIO'] == 14)
		{

			$data['STICMS'] 	= $tab['STICMS'];
			$data['STIPI'] 		= $tab['STIPI'];
			$data['STPIS'] 		= $tab['STPIS'];
			$data['STCOFINS'] 	= $tab['STCOFINS'];

			$tabicms  	= $table_icms->find($tab['STICMS'])->current();

			if  ($tabicms['ALIQUOTA_ICMS'] == 'S')$data['ALIQUOTA_ICMS_EDIT']   = 'S';
			else $data['ALIQUOTA_ICMS_EDIT']   = 'N';

			if  ($tabicms['VALOR_BASE_CALC_ICMS'] == 'S')$data['VALOR_BASE_CALC_ICMS_EDIT']   = 'S';
			else $data['VALOR_BASE_CALC_ICMS_EDIT']   = 'N';

			if  ($tabicms['VALOR_ICMS'] == 'S')$data['VALOR_ICMS_EDIT']   = 'S';
			else $data['VALOR_ICMS_EDIT']   = 'N';
		}
		else
		{

			if (!is_null($tab['ALIQUOTA_DE_CREDITO']))
			{
				$data['ALIQUOTA_ICMS'] 	= $tab['ALIQUOTA_DE_CREDITO'];

			}
			else
			{
				$data['ALIQUOTA_ICMS'] 			= 0.0;

			}

			$data['STICMS'] 	= $tab['STICMS_SIMPLES'];
			$data['STIPI'] 		= $tab['STIPI_SIMPLES'];
			$data['STPIS'] 		= $tab['STPIS_SIMPLES'];
			$data['STCOFINS'] 	= $tab['STCOFINS_SIMPLES'];

		}

		return $data;

	}

	public function beforeInsert(array data)
	{
		$controller      = Zend_Controller_Front::getInstance()->getRequest();
		$nome_controller = $controller->getControllerName(); //pegar a controladora

		if ($nome_controller == 'programaitem')
		{

			if ($data['STICMS'] == '60')
			{
				$data['ALIQUOTA_ICMS'] 					= 0.00;
				$data['BASE_DE_CALCULO_ICMS'] 			= 0.00;
				$data['TOTAL_ICMS'] 					= 0.00;
				$data['BASE_CALCULO_ICMSST_RETIDO'] 	= 0.00;
				$data['VALOR_ICMSST_RETIDO'] 			= 0.00;

			}
			if ($data['STICMS'] == '40')
			{
				$data['ALIQUOTA_ICMS'] 					= 0.00;
				$data['BASE_DE_CALCULO_ICMS'] 			= 0.00;
				$data['TOTAL_ICMS'] 					= 0.00;

			}

			if ($data['STICMS'] == '41')
			{
				$data['ALIQUOTA_ICMS'] 					= 0.00;
				$data['BASE_DE_CALCULO_ICMS'] 			= 0.00;
				$data['TOTAL_ICMS'] 					= 0.00;

			}

			if ($data['STICMS'] == '50')
			{
				$data['ALIQUOTA_ICMS'] 					= 0.00;
				$data['BASE_DE_CALCULO_ICMS'] 			= 0.00;
				$data['TOTAL_ICMS'] 					= 0.00;

			}

			if ($data['STPIS'] == '07')
			{
				$data['ALIQUOTA_PIS'] 					= 0.00;
				$data['BASE_DE_CALCULO_PIS'] 			= 0.00;
				$data['TOTAL_PIS'] 						= 0.00;

			}

			if ($data['STCOFINS'] == '07')
			{
				$data['ALIQUOTA_COFINS'] 					= 0.00;
				$data['BASE_DE_CALCULO_COFINS'] 			= 0.00;
				$data['TOTAL_COFINS'] 						= 0.00;

			}

			if ($data['STPIS'] == '08')
			{
				$data['ALIQUOTA_PIS'] 					= 0.00;
				$data['BASE_DE_CALCULO_PIS'] 			= 0.00;
				$data['TOTAL_PIS'] 						= 0.00;

			}

			if ($data['STCOFINS'] == '08')
			{
				$data['ALIQUOTA_COFINS'] 				= 0.00;
				$data['BASE_DE_CALCULO_COFINS'] 		= 0.00;
				$data['TOTAL_COFINS'] 					= 0.00;

			}

			if ($data['NCM'] != '')
			{
				$table = new Cisweb_Db_Abstract('ncm');
				$ncm   = $table->find($data['NCM'])->current();

				$data['PERCENTUAL_REDUCAO_BC_ICMS'] 	= $ncm['ICMS_BR'];
				$data['MODALIDADE_BC_ICMS'] 			= $ncm['MODALIDADE_BC_ICMS'];

				if ($data['STICMS'] == '201' || $data['STICMS'] == '10')
				{
					$data['MODALIDADE_BC_ICMSST'] 	= $ncm['MODALIDADE_BC_ICMSST'];
					$data['MVA_ST'] 				= $ncm['ALIQUOTA_ICMS_AC'];
				}
			}
		}
		return parent::beforeInsert($data);
	}


	public function afterInsert($id)
	{

		$controller      = Zend_Controller_Front::getInstance()->getRequest();
		$nome_controller = $controller->getControllerName(); //pegar a controladora

		if ($nome_controller == 'programaitem')
		{

			$table_progr 		= new serv_Model_DbTable_Programa();
			$table_progritem 	= new Cisweb_Db_Abstract('progritens');

			$cliente 		= $id['CLIENTE'];
			$item_progr 	= $id['ITEM_PROGR'];
			$item 	 		= $id['NUM_ITEM'];

			$dados_progr 	= $table_progr->getAdapter()->fetchAll($table_progr->select()->where("CLIENTE = '$cliente' AND ITEM = '$item_progr'"));

			$dados_item 	= $table_progritem->getAdapter()->fetchAll($table_progritem->select()->where("CLIENTE = '$cliente' AND ITEM_PROGR = '$item_progr'"));

			if (count($dados_progr) != 0);// calcula o rateio ...
			{

				$valor_frete_total 		= 0;
				$valor_seguro_total 	= 0;

				$frete 					= $dados_progr[0]['VALOR_FRETE'];
				$seguro 				= $dados_progr[0]['VALOR_SEGURO'];

				$total 					= $this->calcula_total($dados_item);

				foreach ($dados_item as $key => $value)
				{
					$valor_frete 	= 0;
					$valor_seguro 	= 0;

					if ($frete != '')
					{

						$valor_frete 		= ($frete/$total) * $value['PRECO_TOTAL_ITEM'];
						$valor_frete_total += $valor_frete;
						$dif = ($frete - $valor_frete_total);
						if ($dif < 0) $dif1 = ($dif * (-1));
						else $dif1 = $dif;
						if ($dif1 <= 0.05) $valor_frete = ($valor_frete + $dif);

						$valor_frete = number_format($valor_frete, 2 , '.' ,'');
					}


					if ($seguro != '')
					{

						$valor_seguro 		= ($seguro/$total) * $value['PRECO_TOTAL_ITEM'];
						$valor_seguro_total += $valor_seguro;
						$dif = ($seguro - $valor_seguro_total);
						if ($dif < 0) $dif1 = ($dif * (-1));
						else $dif1 = $dif;
						if ($dif1 <= 0.05) $valor_seguro = ($valor_seguro + $dif);

						$valor_seguro = number_format($valor_seguro, 2 , '.' ,'');
					}

					$data['VALOR_FRETE'] 				= $valor_frete;
					$data['VALOR_SEGURO'] 				= $valor_seguro;


					if ($frete != 0 || $seguro != 0 )
					{

						$data['BASE_DE_CALCULO_ICMS'] 		=  $value['QUANTIDADE'] * 	$value['PRECO_UNITARIO']	+ ($valor_frete + $valor_seguro);
						$data['BASE_DE_CALCULO_IPI'] 		=  $value['QUANTIDADE'] *	$value['PRECO_UNITARIO'] 	+ ($valor_frete + $valor_seguro);
						$data['BASE_DE_CALCULO_PIS'] 		=  $value['QUANTIDADE'] *	$value['PRECO_UNITARIO'] 	+ ($valor_frete + $valor_seguro);
						$data['BASE_DE_CALCULO_COFINS'] 	=  $value['QUANTIDADE'] *	$value['PRECO_UNITARIO'] 	+ ($valor_frete + $valor_seguro);

						$data['TOTAL_ICMS'] 				=  $data['BASE_DE_CALCULO_ICMS'] * ($value['ALIQUOTA_ICMS'] / 100);
						$data['TOTAL_IPI'] 					=  $data['BASE_DE_CALCULO_IPI'] * ($value['ALIQUOTA_IPI'] / 100);
						$data['TOTAL_PIS'] 					=  $data['BASE_DE_CALCULO_PIS'] * ($value['ALIQUOTA_PIS'] / 100);
						$data['TOTAL_COFINS'] 				=  $data['BASE_DE_CALCULO_COFINS'] * ($value['ALIQUOTA_COFINS'] / 100);

					}

					$iditem 		= $value['ID'];
					$whereitens 	= "ID = '$iditem'";
					$table_progritem->update($data,$whereitens);

				}

			}

		}

	}


	public function calcula_total($dados_item)
	{
		$total = 0;

		foreach ($dados_item as $key => $value)
		{

				$total 		+= $value['PRECO_TOTAL_ITEM'];
		}

		return $total;
	}


	public function beforeUpdate(array $data, $where)
	{
		$controller      = Zend_Controller_Front::getInstance()->getRequest();
		$nome_controller = $controller->getControllerName(); //pegar a controladora

		if ($nome_controller == 'programaitem')
		{

			if ($data['STICMS'] == '40')
			{
				$data['ALIQUOTA_ICMS'] 					= 0.00;
				$data['BASE_DE_CALCULO_ICMS'] 			= 0.00;
				$data['TOTAL_ICMS'] 					= 0.00;

			}

			if ($data['STICMS'] == '41')
			{
				$data['ALIQUOTA_ICMS'] 					= 0.00;
				$data['BASE_DE_CALCULO_ICMS'] 			= 0.00;
				$data['TOTAL_ICMS'] 					= 0.00;

			}

			if ($data['STICMS'] == '50')
			{
				$data['ALIQUOTA_ICMS'] 					= 0.00;
				$data['BASE_DE_CALCULO_ICMS'] 			= 0.00;
				$data['TOTAL_ICMS'] 					= 0.00;

			}

			if ($data['STICMS'] == '60')
			{
				$data['ALIQUOTA_ICMS'] 					= 0.00;
				$data['BASE_DE_CALCULO_ICMS'] 			= 0.00;
				$data['TOTAL_ICMS'] 					= 0.00;
				$data['BASE_CALCULO_ICMSST_RETIDO'] 	= 0.00;
				$data['VALOR_ICMSST_RETIDO'] 			= 0.00;

			}

			if ($data['STPIS'] == '07')
			{
				$data['ALIQUOTA_PIS'] 					= 0.00;
				$data['BASE_DE_CALCULO_PIS'] 			= 0.00;
				$data['TOTAL_PIS'] 						= 0.00;

			}

			if ($data['STCOFINS'] == '07')
			{
				$data['ALIQUOTA_COFINS'] 					= 0.00;
				$data['BASE_DE_CALCULO_COFINS'] 			= 0.00;
				$data['TOTAL_COFINS'] 						= 0.00;

			}

			if ($data['STPIS'] == '08')
			{
				$data['ALIQUOTA_PIS'] 					= 0.00;
				$data['BASE_DE_CALCULO_PIS'] 			= 0.00;
				$data['TOTAL_PIS'] 						= 0.00;

			}

			if ($data['STCOFINS'] == '08')
			{
				$data['ALIQUOTA_COFINS'] 				= 0.00;
				$data['BASE_DE_CALCULO_COFINS'] 		= 0.00;
				$data['TOTAL_COFINS'] 					= 0.00;

			}

			if ($data['STICMS'] == '00' && $data['BASE_DE_CALCULO_ICMS'] == '00.0')
			{
				$data['BASE_DE_CALCULO_ICMS'] 			= $data['PRECO_TOTAL_ITEM'];
			}

			if (isset($data['NCM']) && $data['NCM'] != '')
			{
				$table = new Cisweb_Db_Abstract('ncm');
				$ncm   = $table->find($data['NCM'])->current();

				$data['PERCENTUAL_REDUCAO_BC_ICMS'] 	= $ncm['ICMS_BR'];
				$data['MODALIDADE_BC_ICMS'] 			= $ncm['MODALIDADE_BC_ICMS'];

				if ($data['STICMS'] == '201' || $data['STICMS'] == '10')
				{
					$data['MODALIDADE_BC_ICMSST'] 	= $ncm['MODALIDADE_BC_ICMSST'];
					$data['MVA_ST'] 				= $ncm['ALIQUOTA_ICMS_AC'];
				}
			}
		}

		return parent::beforeUpdate($data, $where);

	}

	public function afterUpdate($id,$where)
	{

		$controller      = Zend_Controller_Front::getInstance()->getRequest();
		$nome_controller = $controller->getControllerName(); //pegar a controladora

		if ($nome_controller == 'programaitem')
		{

			$table_progr 		= new serv_Model_DbTable_Programa();
			$table_progritem 	= new Cisweb_Db_Abstract('progritens');

			$cliente 		= $where[' CLIENTE = ? '];
			$item_progr 	= $where[' ITEM_PROGR = ? '];
			$item 	 		= $where[' NUM_ITEM = ? '];

			$dados_progr 	= $table_progr->getAdapter()->fetchAll($table_progr->select()->where("CLIENTE = '$cliente' AND ITEM = '$item_progr'"));


			$dados_item 	= $table_progritem->getAdapter()->fetchAll($table_progritem->select()->where("CLIENTE = '$cliente' AND ITEM_PROGR = '$item_progr'"));

			if (count($dados_progr) != 0);// calcula o rateio ...
			{

				$valor_frete_total 		= 0;
				$valor_seguro_total 	= 0;

				$frete 					= $dados_progr[0]['VALOR_FRETE'];
				$seguro 				= $dados_progr[0]['VALOR_SEGURO'];

				$total 					= $this->calcula_total($dados_item);

				foreach ($dados_item as $key => $value)
				{
					$valor_frete 	= 0;
					$valor_seguro 	= 0;

					if ($frete != '')
					{

						$valor_frete 		= ($frete/$total) * $value['PRECO_TOTAL_ITEM'];
						$valor_frete_total += $valor_frete;
						$dif = ($frete - $valor_frete_total);
						if ($dif < 0) $dif1 = ($dif * (-1));
						else $dif1 = $dif;
						if ($dif1 <= 0.05) $valor_frete = ($valor_frete + $dif);

						$valor_frete = number_format($valor_frete, 2 , '.' ,'');
					}


					if ($seguro != '')
					{

						$valor_seguro 		= ($seguro/$total) * $value['PRECO_TOTAL_ITEM'];
						$valor_seguro_total += $valor_seguro;
						$dif = ($seguro - $valor_seguro_total);
						if ($dif < 0) $dif1 = ($dif * (-1));
						else $dif1 = $dif;
						if ($dif1 <= 0.05) $valor_seguro = ($valor_seguro + $dif);

						$valor_seguro = number_format($valor_seguro, 2 , '.' ,'');
					}

					$data['VALOR_FRETE'] 				= $valor_frete;
					$data['VALOR_SEGURO'] 				= $valor_seguro;

					if ($frete != 0 || $seguro != 0 )
					{
						$data['BASE_DE_CALCULO_ICMS'] 		=  $value['QUANTIDADE'] * 	$value['PRECO_UNITARIO']	+ ($valor_frete + $valor_seguro);
						$data['BASE_DE_CALCULO_IPI'] 		=  $value['QUANTIDADE'] *	$value['PRECO_UNITARIO'] 	+ ($valor_frete + $valor_seguro);
						$data['BASE_DE_CALCULO_PIS'] 		=  $value['QUANTIDADE'] *	$value['PRECO_UNITARIO'] 	+ ($valor_frete + $valor_seguro);
						$data['BASE_DE_CALCULO_COFINS'] 	=  $value['QUANTIDADE'] *	$value['PRECO_UNITARIO'] 	+ ($valor_frete + $valor_seguro);

						$data['TOTAL_ICMS'] 				=  $data['BASE_DE_CALCULO_ICMS'] * ($value['ALIQUOTA_ICMS'] / 100);
						$data['TOTAL_IPI'] 					=  $data['BASE_DE_CALCULO_IPI'] * ($value['ALIQUOTA_IPI'] / 100);
						$data['TOTAL_PIS'] 					=  $data['BASE_DE_CALCULO_PIS'] * ($value['ALIQUOTA_PIS'] / 100);
						$data['TOTAL_COFINS'] 				=  $data['BASE_DE_CALCULO_COFINS'] * ($value['ALIQUOTA_COFINS'] / 100);
					}

					$iditem 		= $value['ID'];
					$whereitens 	= "ID = '$iditem'";
					$table_progritem->update($data,$whereitens);

				}

			}

		}
	}


	public function beforeDelete($where)
	{

		$controller      = Zend_Controller_Front::getInstance()->getRequest();
		$nome_controller = $controller->getControllerName(); //pegar a controladora

		if ($nome_controller == 'programaitem')
		{

			$table_progr 		= new serv_Model_DbTable_Programa();
			$table_progritem 	= new Cisweb_Db_Abstract('progritens');

			$cliente 			= $where[' CLIENTE = ? '];
			$item_progr 		= $where[' ITEM_PROGR = ? '];
			$item 	 			= $where[' NUM_ITEM = ? '];

			$dados_progr 		= $table_progr->getAdapter()->fetchAll($table_progr->select()->where("CLIENTE = '$cliente' AND ITEM = '$item_progr'"));

			$dados_item 		= $this->getAdapter()->fetchAll($this->select()->where("CLIENTE = '$cliente' AND ITEM_PROGR = '$item_progr' AND NUM_ITEM <> '$item'"));

			if (count($dados_progr) != 0);// calcula o rateio ...
			{

				$valor_frete_total 		= 0;
				$valor_seguro_total 	= 0;

				$frete 					= $dados_progr[0]['VALOR_FRETE'];
				$seguro 				= $dados_progr[0]['VALOR_SEGURO'];

				$total 					= $this->calcula_total($dados_item);

				foreach ($dados_item as $key => $value)
				{
					$valor_frete 	= 0;
					$valor_seguro 	= 0;

					if ($frete != '')
					{

						$valor_frete 		= ($frete/$total) * $value['PRECO_TOTAL_ITEM'];
						$valor_frete_total += $valor_frete;
						$dif = ($frete - $valor_frete_total);
						if ($dif < 0) $dif1 = ($dif * (-1));
						else $dif1 = $dif;
						if ($dif1 <= 0.05) $valor_frete = ($valor_frete + $dif);

						$valor_frete = number_format($valor_frete, 2 , '.' ,'');
					}

					if ($seguro != '')
					{

						$valor_seguro 		= ($seguro/$total) * $value['PRECO_TOTAL_ITEM'];
						$valor_seguro_total += $valor_seguro;
						$dif = ($seguro - $valor_seguro_total);
						if ($dif < 0) $dif1 = ($dif * (-1));
						else $dif1 = $dif;
						if ($dif1 <= 0.05) $valor_seguro = ($valor_seguro + $dif);

						$valor_seguro = number_format($valor_seguro, 2 , '.' ,'');
					}

					$data['VALOR_FRETE'] 				= $valor_frete;
					$data['VALOR_SEGURO'] 				= $valor_seguro;

					$data['BASE_DE_CALCULO_ICMS'] 		=  $value['PRECO_TOTAL_ITEM']	+ ($valor_frete + $valor_seguro);
					$data['BASE_DE_CALCULO_IPI'] 		=  $value['PRECO_TOTAL_ITEM']	+ ($valor_frete + $valor_seguro);
					$data['BASE_DE_CALCULO_PIS'] 		=  $value['PRECO_TOTAL_ITEM']	+ ($valor_frete + $valor_seguro);
					$data['BASE_DE_CALCULO_COFINS'] 	=  $value['PRECO_TOTAL_ITEM']	+ ($valor_frete + $valor_seguro);

					$iditem 		= $value['ID'];
					$whereitens 	= "ID = '$iditem'";
					$table_progritem->update($data,$whereitens);

				}

			}

		}

		return parent::beforeDelete($where);
	}


	public function getEmpresa($emp)
	{

		$table = new core_Model_DbTable_Empresa();
		$dados = $table->find($emp)->toArray();

		return $dados[0];
	}

	public function Buscapreco($prod,$cli,$tipo)
	{
		if ($tipo == 'L')
		{

			$table = new core_Model_DbTable_Ativoprodutos();
			$dados = $table->find($prod);
			return $dados;

		}
		elseif ($tipo == 'P')
		{
			$table = new core_Model_DbTable_ProdutoCliente();
			$dados = $table->findMultipleKey(array($prod,$cli));
			return $dados;
		}
	}

	public function impostosAction()
	{

	    die("Jefferson");

	    $id 		= $this->_request->getParam("id");
	    echo json_encode($this->getImposto($id));
	    die();
	}
}
?>