<?php

class Zsam_Controller_Base extends Zend_Controller_Action {

    protected $campos = array();
    protected $filtro;
    protected $charEncoding = 'UTF-8';
    protected $model;

    public function pdf($sql) {
        $this->_helper->layout->disableLayout();
        $this->_helper->viewRenderer->setNoRender();

        $pdf = new Zend_Pdf();


        $page = $pdf->newPage(Zend_Pdf_Page::SIZE_A4);
        $pdf->pages[] = $page;
        $page->setFont(Zend_Pdf_Font::fontWithName(Zend_Pdf_Font::FONT_HELVETICA_BOLD), 10);

        /* Configuração das variáveis para controle de largura(x) e altura(y) da página */
        $x = 0;
        $y = 800;
        $tamanhoCampos = 595 / sizeof($this->campos['linha1']);
        #Contador de páginas

        for ($r = 0; $r < sizeof($sql); $r++) {
           foreach ($this->campos as $k => $v) {

                if ($y <= 0) {
                    $page = $pdf->newPage(Zend_Pdf_Page::SIZE_A4);
                    $pdf->pages[] = $page;
                    $x = 0;
                    $y = 800;
                }
                $tamanhoCampos = 595 / sizeof($v);


                for ($j = 0; $j < sizeof($v); $j++) {
                    /* Aqui eu monto a primeira linha, primeiro o nome de cada campo */
                    $page->setFont(Zend_Pdf_Font::fontWithName(Zend_Pdf_Font::FONT_HELVETICA_BOLD), 10);
                    $linha = $this->_helper->getHelper('TratarTexto')->tratar($page, $v[$j], 20, $tamanhoCampos * $j, $y, 10);
                }

                #  Aqui eu retiro 20 da variável y para que ele desça uma linha aproximadamente, lembrando que o zend pdf faz o cálculo do espaço página em pontos, não em pixels.
                $y -= 20;

                /* Verifco se existe a necessidade de criar uma nova página */
                if ($y <= 0) {
                    $page = $pdf->newPage(Zend_Pdf_Page::SIZE_A4);
                    $pdf->pages[] = $page;
                    $x = 0;
                    $y = 800;
                    $tamanhoCampos = 595 / sizeof($v);
                }

                /* Aqui eu imprimo o resultado da pesquisa referente a primeira linha */


                # a variável maiorLinha serve para cálcular qual foi a entrada que ocupou mais linhas.
                $maiorLinha = 0;
                for ($j = 0; $j <= sizeof($k); $j++) {
                    $page->setFont(Zend_Pdf_Font::fontWithName(Zend_Pdf_Font::FONT_HELVETICA), 10);
                    $linha = $this->_helper->getHelper('TratarTexto')->tratar($page, $sql[$r]["$v[$j]"], 20, $tamanhoCampos * $j, $y, 10);
                    $maiorLinha = ($linha['x'] > $maiorLinha) ? $linha['x'] : $maiorLinha;
                }

                #  Desço mais uma linha

                $y -= 20;

                $fim = array_diff($v, end($this->campos));
                if (empty($fim)) {
                    $page->drawLine(0, $y - (10 * $maiorLinha), 595, $y - (10 * $maiorLinha));
                    $y -= 65;
                }
            }
        }
        //$page->drawText($texto, 0, 842-10);842x595

        foreach ($pdf->pages as $k) {
            $page->setFont(Zend_Pdf_Font::fontWithName(Zend_Pdf_Font::FONT_HELVETICA_BOLD), 10);
            $this->_helper->getHelper('Header')->montaHeader($page, (int)$k, count($pdf->pages));
        }

        $pdfData = $pdf->render();

        header("Content-Disposition: inline; filename=relatorio.pdf");
        header("Content-type: application/x-pdf");
        echo $pdfData;
        exit;
    }

    public function setCampos($cam) {
        return $this->campos = $cam;
    }

    public function filtrarResultado($sql, $campo) {
        $resultados = array();
        foreach ($sql as $k => $v) {
            if (in_array($v, $campo)) {
                $resultados["$v"] = $v;
                next($campo);
            }
        }

        return $resultados;
    }

}

?>