<?php

class Zsam_Controller_Relatorio_Base extends Zend_Controller_Action {

    protected $campos = array();
    protected $filtro;
    protected $charEncoding = 'UTF-8';
    protected $model;

    public function setCampos($cam) {
        $this->campos = $cam;
    }

    public function getCampos() {
        return $this->campos;
    }

    public function setModel($m) {
        $this->model = 'core_Model_DbTable_' . $m . '()';
    }

    public function getModel() {
        return $this->model;
    }

    public function setFiltro($fil) {
        $this->filtro = $fil;
    }

    public function getFiltro() {
        return $this->filtro;
    }

    public function gerarPdf() {
        $pdf = new Zend_Pdf();
        $page = $pdf->newPage(Zend_Pdf_Page::SIZE_A4);

        $pdf->pages[] = $page;

        $eixoy = 0;
        foreach ($this->campos as $k => $v) {
            if (!is_numeric($v))
                $page->drawText($campos, $x, $y, $this->charEncoding);
            else
                $page->drawText($campos, $x, $x + $v, $this->charEncoding);

            $eixoy += $v;

            if ($eixoy < $page->getWidth())
                $campo_pagina[$k] = $v;
            elseif ($eixoy < (2 * $page->getWidth()))
                $campos_pagina2[$k] = $v;
            else
                $campos_pagina3[$k] = $v;
        }

        $table = new $this->model;

        $select = $table->select();

        if (!empty($this->filtro))
            $select = $select->where($this->filtro);
        $c = 0;
        while ($resultado = $table->getAdpater()->fetchAll($select)->toArray()) {
            imprimeLinha($campo_pagina,$page,$resultado,$c,$x,$y);
            $c++;
        }
    }
    
    public function imprimeLinha($var_campo,$var_page,$var_sql,$var_cont,$eixox,$eixoy){
        foreach ($var_campo as $k => $v) {
                return $var_page->drawText($var_sql[$cont][$var_campo[$k]], $eixox, $eixoy);
            }
    }

}

?>
